%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: read_intervals_csv
%
% Scope:    import timestamps of gas type transitions (intervals) from an
% external csv file
%
% Input:    file name CSV data file (string),
%           directory CSV data file (string),
%           index plot requested (double)
%
% Output:   updated data struture with replaced MPV position data,
%           overview figure (if requested)   
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%
function data = read_intervals_csv(data, filename_csv,pathname_csv, plot_requested)

tic;fprintf('Running function read_intervals_csv...\n');

datatable = readtable([pathname_csv filename_csv]);
%datatable = readtable('C:\Users\brsi\Desktop\IsotopeRead_Matlab\IsotopeRead_Picarro_N2O_app_alpha_v10\Example dataset\intervals_example_20240306.csv');

%read time from csv file
data_csv.date_string= string(datatable.('date'));
data_csv.time_string= string(datatable.('time'));

%get timestamp
for i=1:height(data_csv.time_string)
    data_csv.datetime_string(i,1)=join([data_csv.date_string(i,1), data_csv.time_string(i,1)]);
end

data_csv.all=datenum(data_csv.datetime_string,'dd.mm.yyyy HH:MM:SS');     

%data_csv.all(:,2)=(data_csv.all(:,1)-data.all(1,1))*24;         %relative time in h
data_csv.all(:,2)=(data_csv.all(:,1)-datenum(data.start_time_string,'yyyy-mm-dd HH:MM:SS.FFF'))*24;         %relative time in h

%read sample column from csv file
data_csv.all(:,3) = datatable.('sample');

% interpolate csv data to main instrument time grid
for i=1:height(data_csv.all)
        [~,minidx] = min(abs(data.all(:,2)-data_csv.all(i,2)));    
    data_csv.check_idx(i,1)=minidx;
end

%% write csv intervals in data.all vector (column 12) 

for i=1:height(data.all)   
    if data.all(i,2)<data_csv.all(1,2)
        data.all(i,12)=NaN;
    end
    for k=1:height(data_csv.all)-1
        if data.all(i,2)>data_csv.all(k,2) && data.all(i,2)<data_csv.all(k+1,2) 
            data.all(i,12)=data_csv.all(k,3);
        end
    end
    if data.all(i,2)>data_csv.all(end,2)
        data.all(i,12)=data_csv.all(end,3);
    end
    if isnan(data.all(i,2))
        data.all(i,12)=NaN;
    end
end

%% find interval boundaries (i.e. MPV position changes)

data.boundaries_idx = find(ischange(data.all(:,12))==1);
data.boundaries_idx = transpose([1 transpose([data.boundaries_idx]) height(data.all)]);

%% calculate mean time resolution

delta_t = diff(data.all(:,2))*60*60; %s  
data.time_res=mean(delta_t);       

%% remove MPV "transition" switches (i.e. MPV position changes closer in time than 20 s)

discard_idx=round(20/data.time_res);

 check_boundaries=[];
 for i=1:height(data.boundaries_idx)-1
    if data.boundaries_idx(i+1,1)-data.boundaries_idx(i,1)<discard_idx
        check_boundaries=[check_boundaries find(data.boundaries_idx==data.boundaries_idx(i+1,1))];
    end
 end
 
 data.boundaries_idx(check_boundaries,1)=NaN;
 data.boundaries_idx(end,1)=height(data.all);
 data.boundaries_idx=rmmissing(data.boundaries_idx);

 %% create "flag" vector

for k=1:height(data.boundaries_idx)-1
    num=0;sum=0;
    for i=data.boundaries_idx(k,1):data.boundaries_idx(k+1,1)
        num=num+1;
        sum=sum+data.all(i,12);
    end
    data.flag(k,1)=round(sum/num);
end
%% plot overview

plotvars=[3 7 5 8 6 11];
if plot_requested
    figure;
    for i=1:6
        subplot(3,2,i);
        plot(data.all(:,2),data.all(:,plotvars(1,i)),'LineWidth',1.5);
        hold on;
        for j=2:height(data.boundaries_idx)-1
            xline(data.all(data.boundaries_idx(j,1),2),'--k');
        end
        %xline(data.all(data.boundaries_idx(2:height(data.boundaries_idx)-1,1),2),'--k');
        grid on;
        box on;
        xlim([0 data.all(end,2)]);
        ylabel({sprintf('%s',data.varlabels{1,plotvars(1,i)})},'fontsize',12);
        if i==1
        title('Overview PICARRO G5131-{\iti}','fontsize',12); end    
        if i==5 || i==6
        xlabel({sprintf('%s',data.varlabels{1,2})},'fontsize',12); end
    end
    
    x0 = 10;
    y0 = 50;
    ww = 900;
    hh = 700;
    set(gcf,'units','points','position',[x0,y0,ww,hh]);
    set(gcf,'Units','Inches');
    pos = get(gcf,'Position');
    set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3),pos(4)]);
end
%print(gcf,'C:\Users\brsi\Desktop\overview_N2O','-dpng', '-r800');

%%
time_elapsed=toc; fprintf('read_intervals_csv completed (execution time: %1.2f s)\n',time_elapsed); 

end